#include <stdio.h>
#include <vector>
#include <algorithm>
#include <math.h>

using namespace std;

struct Pt {
    int idx;
    double x, y;
    int cx, cy; // indeksi celije
};

int main() {
    int n;
    double eps;
    if (scanf("%d %lf", &n, &eps) != 2) return 0;
    vector<Pt> pts(n);
    for (int i = 0; i < n; i++) {
        double xi, yi;
        scanf("%lf %lf", &xi, &yi);
        pts[i] = {i+1, xi, yi, 0, 0};
    }

    // velicina celije d = eps / 3
    double d = eps / 3.0;
    if (d <= 0) d = 1e-3;

    // mapiranje: jedna tacka (prva po pojavljivanju) po celiji
    // koristimo hashing preko parova (cx, cy) u bucket mapu
    // da ostanemo u stdio.h, napravimo prost hash tabelu sa linear probingom
    struct Cell { int cx, cy; int idx; bool used; };
    int gridCap = max(1024, min(1<<20, (int)(12.0/(eps*eps))+1024)); // kapacitet hash tabele
    vector<Cell> table(gridCap);
    for (int i = 0; i < gridCap; i++) table[i] = {0,0,-1,false};

    auto hashKey = [&](int cx, int cy)->unsigned int {
        // 64-bit mix
        unsigned long long k = ((unsigned long long)(unsigned int)cx << 32) ^ (unsigned long long)(unsigned int)cy;
        k ^= k >> 33; k *= 0xff51afd7ed558ccdULL;
        k ^= k >> 33; k *= 0xc4ceb9fe1a85ec53ULL;
        k ^= k >> 33;
        return (unsigned int)(k & (gridCap - 1));
    };

    vector<int> Q; Q.reserve(n);
    for (int i = 0; i < n; i++) {
        int cx = (int)floor(pts[i].x / d);
        int cy = (int)floor(pts[i].y / d);
        if (cx < 0) cx = 0; if (cy < 0) cy = 0;
        pts[i].cx = cx; pts[i].cy = cy;
        unsigned int h = hashKey(cx, cy);
        for (int step = 0; step < gridCap; step++) {
            int pos = (h + step) & (gridCap - 1);
            if (!table[pos].used) {
                table[pos] = {cx, cy, i, true};
                Q.push_back(i); // cuvamo indeks u pts vektoru
                break;
            } else if (table[pos].cx == cx && table[pos].cy == cy) {
                // celija vec ima predstavnika: preskacemo
                break;
            }
        }
    }

    int k = (int)Q.size();
    if (k == 0) {
        printf("0\n\n");
        return 0;
    }

    // Prim na Q sa Manhattan metrikom
    vector<char> vis(k, 0);
    vector<double> best(k, 1e100);
    vector<int> parent(k, -1);

    // inicijalizuj od 0-tog
    best[0] = 0.0;
    double (*dist)(const Pt&, const Pt&) = [](const Pt& a, const Pt& b)->double {
        return fabs(a.x - b.x) + fabs(a.y - b.y);
    };

    for (int iter = 0; iter < k; iter++) {
        int u = -1;
        double bu = 1e100;
        for (int i = 0; i < k; i++) {
            if (!vis[i] && best[i] < bu) {
                bu = best[i];
                u = i;
            }
        }
        if (u == -1) break;
        vis[u] = 1;
        // relaksacija
        for (int v = 0; v < k; v++) {
            if (!vis[v]) {
                double w = dist(pts[Q[u]], pts[Q[v]]);
                if (w < best[v]) {
                    best[v] = w;
                    parent[v] = u;
                }
            }
        }
    }

    // Ispis
    printf("%d\n", k);
    for (int i = 0; i < k; i++) {
        printf("%d%c", pts[Q[i]].idx, (i+1==k)?'\n':' ');
    }
    for (int i = 0; i < k; i++) {
        if (parent[i] != -1) {
            int a = pts[Q[i]].idx;
            int b = pts[Q[parent[i]]].idx;
            printf("%d %d\n", b, a);
        }
    }

    return 0;
}